﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager; 
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class controls_FragLabResult : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
    }

    public void BindData(WKF_CASE_ACTIVITY Activity, WKF_CASE_ACTIVITY Order, bool fullRefresh)
    {
        //boolean fullRefresh is added since deserialize is not persisting the analysismethod and fragment type values

        if (Activity != null)
        {
            if (fullRefresh == true)
            {

                WKF_CASE_ACTIVITY interpretation = Activity.WKF_CASE.WKF_CASE_ACTIVITies
                    .Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation)).FirstOrDefault();

                if (interpretation != null &&
                        (interpretation.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.New ||
                            interpretation.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess)) 
                {

                    patientWorkflowsLink.Text = Activity.WKF_CASE.REFERRAL.PATIENT.FullName;
                    patientWorkflowsLink.NavigateUrl = String.Format("~/PatientWorkflows.aspx?patientId={0}", Activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ID);   
                    lblFullName.Visible = false;
                    patientWorkflowsLink.Visible = true;
                    LabelforFullNameLabel.AssociatedControlID = patientWorkflowsLink.ID;
                }
                else
                {
                    lblFullName.Text = Activity.WKF_CASE.REFERRAL.PATIENT.FullName;
                    lblFullName.Visible = true;
                    patientWorkflowsLink.Visible = false;
                    LabelforFullNameLabel.AssociatedControlID = lblFullName.ID;
                }
                //lblFullName.Text = Activity.WKF_CASE.REFERRAL.PATIENT.FullName;
                lblICN.Text = Activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ICN;
                lblSnum.Text = Activity.WKF_CASE.REFERRAL.PATIENT.Snum;
                if(Activity.WKF_CASE.REFERRAL.PATIENT.BIRTH_DATE.HasValue)
                    lblBirthday.Text = Activity.WKF_CASE.REFERRAL.PATIENT.BIRTH_DATE.GetValueOrDefault().ToShortDateString();
                if(Activity.WKF_CASE.REFERRAL.PATIENT.STD_GENDER != null)
                    lblGender.Text = Activity.WKF_CASE.REFERRAL.PATIENT.STD_GENDER.NAME;
                
                
                
                if (Order.LAB_ORDERs.Count() > 0) 
                {
                    if (Order.LAB_ORDERs.First().LAB_REPORT_DATE.HasValue)
                        txtLabRptDate.Text = Order.LAB_ORDERs.First().LAB_REPORT_DATE.GetValueOrDefault().ToShortDateString();
                    txtAccession.Text = Order.LAB_ORDERs.First().BSO_NUMBER;
                    txtLabID.Text = Order.LAB_ORDERs.First().LAB_ID_NUMBER;
                    txtLabCd.Text = Order.LAB_ORDERs.First().METALS_LAB_CODE;
                }
            }
            //Populate Analyte details
            if (Activity.FRAGMENT_ANALYSIs.Count() == 0)
            {
                GridViewEFRFragments.DataSource = new List<FRAGMENT_ANALYSI>();
            }
            if (Activity.FRAGMENT_ANALYSIs.Count() > 0)
                GridViewEFRFragments.DataSource = Activity.FRAGMENT_ANALYSIs;

            GridViewEFRFragments.DataBind();

        }
    }


    public void Fragments_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            //Deserialize();

            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRFragments.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRFragments.SelectedValue);
            Response.Redirect("FragLabInterpretationFragment.aspx?fragmentId={0}", id);

        }        

    }
}
